package examples.localserver;

import ru.uss.esf.api1.invoice.InvoiceIdWithReason;
import ru.uss.esf.api1.invoice.signable.IdWithReasonList;
import ru.uss.esf.model.SignableDataContainer;

import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import java.util.List;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ListWithReasonSignatureRequest")
public class ListWithReasonSignatureRequest implements SignableDataContainer<IdWithReasonList> {
    @XmlElementWrapper(required = true)
    @XmlElement(name = "idWithReason", required = true)
    private List<InvoiceIdWithReason> idsWithReasons;

    @XmlElement(required = true)
    @Documentation("Путь к сертификату на локальном компьютере")
    private String certificatePath;

    @XmlElement(required = true)
    @Documentation("Пароль к контейнеру с сертификатом")
    private String certificatePin;

    public List<InvoiceIdWithReason> getIdsWithReasons() {
        return idsWithReasons;
    }

    public void setIdsWithReasons(List<InvoiceIdWithReason> idsWithReasons) {
        this.idsWithReasons = idsWithReasons;
    }

    public String getCertificatePath() {
        return certificatePath;
    }

    public void setCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
    }

    public String getCertificatePin() {
        return certificatePin;
    }

    public void setCertificatePin(String certificatePin) {
        this.certificatePin = certificatePin;
    }

    @Override
    public IdWithReasonList getSignableData() {
        return new IdWithReasonList(idsWithReasons);
    }
}
